﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        private UtilityBL _UtilityBL = null;

        public UtilityBL Utility
        {
            get
            {
                if (_UtilityBL == null)
                {
                    _UtilityBL = new UtilityBL(this);
                }

                return _UtilityBL;
            }
        }

        public class UtilityBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
        {
            public UtilityBL(ZSBELearning BL) : base(BL) { }

            public int PointPercent(int? Point, int? MaxPoint)
            {
                return BasicUtility.PointPercent(Point ?? 0, MaxPoint ?? 0);
            }

            public BL.ZSBELearning.ContextParam GetValidContext(BL.BO.Student Student)
            {
                BL.ZSBELearning.ContextParam _ContextParam = null;
                long? _courseID = null;
                long? _contextObjectID = null;

                #region Kursy początkowe
                if ((_ContextParam == null) && (Student.KnowledgeTestStartAdvancedLevelID == null))
                {
                    _courseID = BLP.RBL.VariableRepository.GetLong(BL.Dictionary.Config.Tests.StartKnowledgeTest.CourseID, BL.Dictionary.Clients.PlugIn);
                    _contextObjectID = BL.Dictionary.Config.Tests.StartKnowledgeTest.ContextObjectID;

                    if (_courseID.HasValue && _contextObjectID.HasValue)
                    {
                        _ContextParam = new ContextParam(BLP, _contextObjectID, _courseID, null, GM.N610.ELearning.BL.Dictionary.ModeType.None);
                    }
                }                

                if ((_ContextParam == null) && (Student.AdvancedTestStartEvaluationSheetID == null))
                {
                    _courseID = BLP.RBL.VariableRepository.GetLong(BL.Dictionary.Config.Tests.StartAdvancedTest.CourseID, BL.Dictionary.Clients.PlugIn);
                    _contextObjectID = BL.Dictionary.Config.Tests.StartAdvancedTest.ContextObjectID;

                    if (_courseID.HasValue && _contextObjectID.HasValue)
                    {
                        _ContextParam = new ContextParam(BLP, _contextObjectID, _courseID, null, GM.N610.ELearning.BL.Dictionary.ModeType.None);
                    }
                }
                #endregion

                #region Odszukujemy już rozpoczętą kompetencje składową
                if (_ContextParam == null) 
                {
                    BO.Student_CompetencePart.Search _search = new BO.Student_CompetencePart.Search();
                    _search.IsEnded = false;
                    _search.IsStarted = true;
                    _search.StudentID = Student.ID;

                    BO.Student_CompetencePart _Student_CompetencePart = BLP.Statistic.Student.CompetencePart.RestoreTopOne(_search);

                    if (_Student_CompetencePart != null)
                    {
                        BO.CompetencePart _CompetencePart = BLP.CompetencePart.Restore(_Student_CompetencePart.CompetencePartID);

                        if (_CompetencePart != null)
                        {
                            if (_Student_CompetencePart.IsCourseDone == false)
                            {
                                _courseID = _CompetencePart.CompetenceCourseID;
                            }
                            else
                            {
                                _courseID = _CompetencePart.CaseID;
                            }

                            _contextObjectID = _CompetencePart.ID;
                            _ContextParam = new ContextParam(BLP, _contextObjectID, _courseID, null, GM.N610.ELearning.BL.Dictionary.ModeType.None);
                        }
                    }
                }
                #endregion

                #region Odzyskujemy pierwsza w kolejności wag kompetencje składową odblokowana i nie zrobioną
                if (_ContextParam == null)
                {
                    BO.CompetencePart _CompetencePart = BLP.CompetencePart.Restore(Student);

                    if (_CompetencePart != null)
                    {
                        _courseID = _CompetencePart.CompetenceCourseID;
                        _contextObjectID = _CompetencePart.ID;
                        _ContextParam = new ContextParam(BLP, _contextObjectID, _courseID, null, GM.N610.ELearning.BL.Dictionary.ModeType.None);
                    }
                }
                #endregion

                #region Kursy końcowe
                if ((_ContextParam == null) &&(Student.KnowledgeTestEndAdvancedLevelID == null))
                {
                    _courseID = BLP.RBL.VariableRepository.GetLong(BL.Dictionary.Config.Tests.EndKnowledgeTest.CourseID, BL.Dictionary.Clients.PlugIn);
                    _contextObjectID = BL.Dictionary.Config.Tests.EndKnowledgeTest.ContextObjectID;

                    if (_courseID.HasValue && _contextObjectID.HasValue)
                    {
                        _ContextParam = new ContextParam(BLP, _contextObjectID, _courseID, null, GM.N610.ELearning.BL.Dictionary.ModeType.None);
                    }
                }

                if ((_ContextParam == null) &&(Student.AdvancedTestEndEvaluationSheetID == null))
                {
                    _courseID = BLP.RBL.VariableRepository.GetLong(BL.Dictionary.Config.Tests.EndAdvancedTest.CourseID, BL.Dictionary.Clients.PlugIn);
                    _contextObjectID = BL.Dictionary.Config.Tests.EndAdvancedTest.ContextObjectID;

                    if (_courseID.HasValue && _contextObjectID.HasValue)
                    {
                        _ContextParam = new ContextParam(BLP, _contextObjectID, _courseID, null, GM.N610.ELearning.BL.Dictionary.ModeType.None);
                    }
                }
                #endregion

                return _ContextParam;
            }
        }
    }
}
